#ifndef SGPHYSIQUE_H
#define SGPHYSIQUE_H

#include "entite.h"

#define g_SGPhysique SGPhysique::getSGPhysique()

class SGPhysique
{
    private:
        static SGPhysique *s_pSGPhysique;
        const int m_iFrequence; // frequence du moteur
        float m_fVitesseMax; // vitesse maximale absolue que peut atteindre une entitee
        // retourne une vitesse v <= m_iVitesseMax
        float controleVitesse( float fV );
        int arrondi(float f);
        float abs(float f);
        
        int inverse(int iDirection);
        void arreter(PhysicData *pPd, int iDirection);
        void ajouterFrottement(PhysicData *pPd, int iDirection);
        void traiterBlocages();
        void replacer(PhysicData *pPd1, PhysicData *pPd2, int direction);
        void ajouterReaction(PhysicData *pPd, int Direction);
        void ajouterRebond(PhysicData *pPd1,PhysicData *pPd2, int Direction);
        void traiterInteractions();
        void restaurerCoordonnees(Entite *pEntite, int iDirection);
        

     public:
        SGPhysique (int iFrequence, float fVitesseMax);
        void calculer();
        void traiterCollisions();
        void majCoordonnees();
        
        static SGPhysique &getSGPhysique() { return *s_pSGPhysique ;}
        
        // teste si le physicData donn en paramtre est en collision avec les entites
        // et retroune soit HAUT, BAS, GAUCHE, DROITE ou AUCUNE
        int getCollision(PhysicData *pPd);
        
        // retourne la valeur de collision entre entite1 et entite2
        // HAUT -> le haut de l'entit1 touche l'entite2
        // BAS -> le bas de l'entit1 touche l'entit2
        // ....
        // AUCUNE -> pas de collision entre entit1 et entit2
        int testerCollisions1(Entite *entite1, Entite *entite2); 
        int testerCollisions2(Entite *entite1, Entite *entite2);     
        // retourne le numero de l'entit
        int testerCollision(const int iX,const int iY);
        int testerCollision(const int iX1,const int iY1,const int iX2,const int iY2);
};

#endif
